% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_Graph.R
\name{getClusterAdjacencyMatrix}
\alias{getClusterAdjacencyMatrix}
\title{Construct an adjacency matrix}
\usage{
getClusterAdjacencyMatrix(cluster, gs_names)
}
\arguments{
\item{cluster}{A \code{list} of clusters, where each cluster member is indicated
by a numeric value}

\item{gs_names}{A vector of geneset names}
}
\value{
A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} of adjacency status
}
\description{
Construct an adjacency matrix from a \code{list} of cluster.
}
\examples{
cluster <- list(c(1:5), c(6:9))
gs_names <- c("a", "b", "c", "d", "e", "f", "g", "h", "i")
adj <- getClusterAdjacencyMatrix(cluster, gs_names)
}
