% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_heatmap.R
\name{distanceHeatmap}
\alias{distanceHeatmap}
\title{Plot a heatmap}
\usage{
distanceHeatmap(
  distance_scores,
  chars_limit = 50,
  plot_labels = TRUE,
  cluster_rows = TRUE,
  cluster_columns = TRUE,
  title = "Distance Scores",
  display_similarity = FALSE,
  quantile_limits = c(0.025, 0.975)
)
}
\arguments{
\item{distance_scores}{A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} of (distance) scores for each
pairwise combination of genesets.}

\item{chars_limit}{Numeric value, Indicates how many characters of the
row and column names of \code{distance_scores} should be
plotted. Defaults to 50 and prevents crowded axes due to
long names.}

\item{plot_labels}{Logical, Indicates if row and collabels should be plotted.
Defaults to TRUE}

\item{cluster_rows}{Logical, Indicates whether or not the rows should be
clustered based on the distance scores. Defaults to TRUE}

\item{cluster_columns}{Logical, Indicates whether or not the rows should be
clustered based on the distance scores. Defaults to
TRUE}

\item{title}{character, a title for the figure. Defaults to "Distance Scores"}

\item{display_similarity}{Logical, Indicates whether or not the scores should be
plotted as a distance matrix (i.e. 0 indicates completely
identical sets) or as a similarity matrix (i.e. 1
indicates completely identical sets). Defaults to FALSE
(i.e. a distance matrix).}

\item{quantile_limits}{Numerical vector, Used to scale the colors in the
heatmap between the given quantiles. Can be helpful in
order to reduce the effect of the diagonal or other
outlier values on the color scheme. Defaults to
c(0.025, 0.975).}
}
\value{
A \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}} plot object.
}
\description{
Plot a heatmap of a matrix of (distance) scores of the input genesets
}
\examples{
## Mock example showing how the data should look like

distance_scores <- Matrix::Matrix(0.5, 20, 20)
distance_scores[c(11:15), c(2:6)] <- 0.2
rownames(distance_scores) <- colnames(distance_scores) <- as.character(c(1:20))
p <- distanceHeatmap(distance_scores)

## Example using the data available in the package
data(scores_macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
p <- distanceHeatmap(scores_macrophage_topGO_example_small)
}
