% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clustering}
\alias{clustering}
\title{Cluster genesets.}
\usage{
clustering(scores, threshold, cluster_method = "louvain")
}
\arguments{
\item{scores}{A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} of (distance) scores}

\item{threshold}{numerical, A threshold used to determine which genesets are
considered similar. Genesets are considered similar if
(distance) score <= threshold.
similar.}

\item{cluster_method}{character, the clustering method to use. The options
are \code{louvain} and \code{markov}. Defaults to \code{louvain}.}
}
\value{
A \code{list} of clusters
}
\description{
This function performs clustering on a set of scores using either the Louvain
or Markov method.
}
\examples{
## Mock example showing how the data should look like
m <- Matrix::Matrix(stats::runif(100, min = 0, max = 1), 10, 10)
rownames(m) <- colnames(m) <- c("a", "b", "c", "d", "e",
                                "f", "g", "h", "i", "j")
cluster <- clustering(m, 0.3, "markov")

## Example using the data available in the package
data(scores_macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())

clustering <- clustering(scores_macrophage_topGO_example_small,
                        threshold = 0.5)
}
