% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{cacheResource}
\alias{cacheResource}
\title{Caching of a resource}
\usage{
cacheResource(res, rname, ucdir = "GSEABenchmarkeR")
}
\arguments{
\item{res}{Resource. An arbitrary R object.}

\item{rname}{Character. Resource name.}

\item{ucdir}{Character. User cache directory. Defaults to 'GSEABenchmarkeR',
which will accordingly use \code{tools::R_user_dir("GSEABenchmarkeR", which = "cache")}.}
}
\value{
None. Stores the object in the cache by side effect.
}
\description{
Convenience function to flexibly save and restore an already processed 
expression data compendium via caching.
}
\examples{

     # load user-defined expression compendium
     data.dir <- system.file("extdata/myEData", package = "GSEABenchmarkeR")
     edat <- loadEData(data.dir)

     # do some processing of the compendium
     edat <- lapply(edat, function(d) d[1:50,])

     # cache it ...
     cacheResource(edat, "myEData")

     # ... and restore it at a later time
     edat <- loadEData(data.dir, cache = TRUE)    

}
\seealso{
\code{\link{loadEData}}, \code{\link{R_user_dir}}, 
\code{\linkS4class{BiocFileCache}}
}
\author{
Ludwig Geistlinger <Ludwig.Geistlinger@sph.cuny.edu>
}
