% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRdrawDRC.R
\name{GRdrawDRC}
\alias{GRdrawDRC}
\title{Dose-Response Curves}
\usage{
GRdrawDRC(
  fitData,
  metric = "GR",
  experiments = "all",
  min = "auto",
  max = "auto",
  points = TRUE,
  curves = TRUE,
  plotly = TRUE
)
}
\arguments{
\item{fitData}{an element of class SummarizedExperiment, generated by the 
GRfit function.}

\item{metric}{either "GR" for GR dose response curves or "rel_cell" for 
traditional dose response curves based on relative cell count.}

\item{experiments}{the names of the experiments to plot (or "all")}

\item{min}{the minimum concentration to plot (for curves)}

\item{max}{the maximum concentration to plot (for curves)}

\item{points}{a logical value indicating whether points (individual GR
values) will be plotted}

\item{curves}{a logical value indicating whether sigmoidal dose-response
curves will be plotted}

\item{plotly}{a logical value indicating whether to output a ggplot2 graph
or a ggplotly graph}
}
\value{
ggplot2 or ggplotly graphs of Growth-rate inhibition dose-response
curves
}
\description{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function plots either the growth-rate inhibition (GR) dose response 
curves or the traditional dose response curves for a given set of data.
}
\details{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function plots these GR values (versus concentration) and/or the
sigmoidal curves fitted to the sets of points. The results can be viewed
in a static ggplot image or an interactive plotly graph.

The "min" and "max" parameters control the concentration values for which
the curves are plotted. They are automatically set to the minimum and
maximum concentrations of the data, but can be set by the user as well.
"min" and "max" take raw values (not log transformed) for concentration.

By default, curves and points are plotted for all experiments. To specify
a smaller set of experiments, use the "experiments" parameter. To see the
names of individual experiments for a GRfit object \code{fit_example}, see
\code{colData(fit_example)}. See the examples below.
}
\examples{
# Load Case A (example 1) input
data("inputCaseA")
# Run GRfit function with case = "A"
drc_output = GRfit(inputCaseA,
groupingVariables = c('cell_line','agent'))
GRdrawDRC(drc_output, experiments = c('BT20 drugA', 'MCF10A drugA',
'MCF7 drugA'), min = 10^(-4), max = 10^2)
GRdrawDRC(drc_output, plotly = FALSE)
}
\seealso{
To create the object needed for this function, see
\code{\link{GRfit}}. For other visualizations, see \code{\link{GRbox}} and
\code{\link{GRscatter}}. For online GR calculator and browser, see
\url{http://www.grcalculator.org}.
}
\author{
Nicholas Clark
}
