% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotCorrelations}
\alias{plotCorrelations}
\title{Plot scatter plots of the underlying count data for either TF-peak, peak-gene or TF-gene pairs for a \code{\linkS4class{GRN}} object}
\usage{
plotCorrelations(
  GRN,
  type = "all.filtered",
  TF.IDs = NULL,
  peak.IDs = NULL,
  gene.IDs = NULL,
  min_abs_r = 0,
  TF_peak_maxFDR = 0.2,
  peak_gene_max_rawP = 0.2,
  TF_gene_max_rawP = 0.2,
  nMax = 10,
  nSelectionType = "random",
  dataType = c("real"),
  corMethod = NULL,
  outputFolder = NULL,
  basenameOutput = NULL,
  plotAsPDF = TRUE,
  plotsPerPage = c(2, 2),
  pdf_width = 10,
  pdf_height = 8,
  forceRerun = FALSE
)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{type}{Character(1). Default \code{"all.filtered"}. Either \code{"TF-peak"}, \code{"peak-gene"}, \code{"TF-gene"}, or \code{"all.filtered"}. Default \code{"all.filtered"}. 
Which connections to plot? \code{"all.filtered"} plots all TF-peak and peak-gene pairs from the filtered eGRN as stored in the object.}

\item{TF.IDs}{Character(). Default \code{NULL}. Character vector of TF IDs to include. If set to \code{NULL}, this filter will be ignored. 
Only applicable when \code{type = "TF-peak"} or \code{type = "TF-gene"}.}

\item{peak.IDs}{Character(). Default \code{NULL}. Character vector of peak IDs to include. If set to \code{NULL}, this filter will be ignored. 
Only applicable when \code{type = "TF-peak"} or \code{type = "peak-gene"}.}

\item{gene.IDs}{Character(). Default \code{NULL}. Character vector of gene IDs (Ensembl) to include. If set to \code{NULL}, this filter will be ignored. 
Only applicable when \code{type = "TF-gene"} or \code{type = "peak-gene"}.}

\item{min_abs_r}{Numeric[0,1]. Default 0. Filter for all types of pairs: Minimum correlation coefficient (absolute value) required to include a particular pair.}

\item{TF_peak_maxFDR}{Numeric[0,1]. Default 0.2. Filter for TF-peak pairs: Which maximum FDR should a pair to plot have? Only applicable when \code{type = "TF-peak"}.}

\item{peak_gene_max_rawP}{Numeric[0,1]. Default 0.2. Filter for peak-gene pairs: Which maximum FDR should a pair to plot have? Only applicable when \code{type = "peak-gene"}.}

\item{TF_gene_max_rawP}{Numeric[0,1]. Default 0.2. Filter for TF-gene pairs: Which maximum FDR should a pair to plot have? Only applicable when \code{type = "TF-gene"}.}

\item{nMax}{Numeric(1). Default 10. Filter for all types of pairs: maximum number of selected pairs that fulfill all other filters that should be plotted.
If set to 0, this filter will be disabled and all pairs that fulfill the user-defined criteria will be plotted. If set to a value > 0, different pairs may be selected each time the function is run
 (if the total number of remaining pairs is large enough)}

\item{nSelectionType}{\code{random} or \code{top}. Default \code{top}. Only applicable if \code{nMax} is set to a value > 0. 
If set to \code{top}, only the top features will be plotted while \code{random} plots randomly selected features.}

\item{dataType}{Character vector. One of, or both of, \code{real} or \code{background}. Default \code{real}. For which type, real or background data, to produce the diagnostic plots?}

\item{corMethod}{Character. Either \code{NULL} (the default) or one of \code{pearson}, \code{spearman} or \code{bicor}. 
Method for calculating the correlation coefficient. If set to \code{NULL}, the correlation method that has been used in the GraNIE object is used.
For testing nd visualizing data, this can be changed, though.
For \code{pearson} and \code{spearman} , see \link{cor} for details. \code{bicor} denotes the *biweight midcorrelation*, a correlation measure based on medians as
calculated by \code{WGCNA::bicorAndPvalue}. Both \code{spearman} and \code{bicor} are considered more robust measures that are less prone to be affected by outliers.}

\item{outputFolder}{Character or \code{NULL}. Default \code{NULL}. If set to \code{NULL}, the default output folder as specified when initiating the 
object in \code{\link{initializeGRN}} will be used. Otherwise, all output from this function will be put into the specified folder. 
If a folder is provided, while we recommend specifying an absolute path, a relative one also works.}

\item{basenameOutput}{\code{NULL} or character. Default \code{NULL}. Basename of the output files that are produced. If set to \code{NULL}, a default basename is chosen. If a custom basename is specified, all output files will have the chosen basename as file prefix, be careful with not overwriting already existing files (if \code{forceRerun} is set to \code{TRUE})}

\item{plotAsPDF}{\code{TRUE} or \code{FALSE}. Default \code{TRUE}.Should the plots be printed to a PDF file? If set to \code{TRUE}, a PDF file is generated, the name of which depends on the value of \code{basenameOutput}. If set to \code{FALSE}, all plots are printed to the currently active device. Note that most functions print more than one plot, which means you may only see the last plot depending on your active graphics device.}

\item{plotsPerPage}{Integer vector of length 2. Default \code{c(2,2)}. How man plots should be put on one page? The first number denotes the number of rows, the second one the number of columns.}

\item{pdf_width}{Number>0. Default 12. Width of the PDF, in cm.}

\item{pdf_height}{Number >0. Default 12. Height of the PDF, in cm.}

\item{forceRerun}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Force execution, even if the GRN object already contains the result. Overwrites the old results.}
}
\value{
An updated \code{\linkS4class{GRN}} object.
}
\description{
The user can select multiple filters to plot only pairs of interest. The data that is shown is the same that has been used to construct the eGRN.
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
GRN = plotCorrelations(GRN, nMax = 1, min_abs_r = 0.8, plotsPerPage = c(1,1), plotAsPDF = FALSE)
}
