% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{resetCallFilter}
\alias{resetCallFilter}
\alias{resetCallFilter,GbsrGenotypeData-method}
\title{Set the origina; data to be used in GBScleanR's functions}
\usage{
resetCallFilter(object, ...)

\S4method{resetCallFilter}{GbsrGenotypeData}(object)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object.
}
\description{
Set the "genotype" node and the "data" node
as primary nodes for genotype
data and read count data. The data stored
in the primary nodes are used in the
functions of GBScleanR.
}
\details{
A \link{GbsrGenotypeData} object storing information of
the primary node of genotype data and
read count data. All of the functions implemented
in \link{GBScleanR} check the primary nodes
and use data stored in those nodes.
\code{\link[=setCallFilter]{setCallFilter()}} create new nodes storing
filtered genotype calls and read counts in
a GDS file and change the primary nodes to
"filt.genotype" and "filt.data" for genotype and
read count data, respectively.
\code{\link[=resetCallFilter]{resetCallFilter()}} set back the nodes to
the original, those are "genotype" and "data" for
genotype and read count data, respectively.
}
\examples{
# Create a GDS file from a sample VCF file.
vcf_fn <- system.file("extdata", "sample.vcf", package = "GBScleanR")
gds_fn <- tempfile("sample", fileext = ".gds")
gbsrVCF2GDS(vcf_fn = vcf_fn, out_fn = gds_fn, force = TRUE)

# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds <- loadGDS(gds_fn)

# Filter out set zero to read counts and
# missing to genotype calls of which meet the criteria.
gds <- setCallFilter(gds, dp_count = c(5, Inf))

# Now any functions of [GBScleanR] reference the genotype data
# stored in the "filt.genotype" node of the GDS file.

# If you need to set the "genotype" node, where store the raw genotype data
# as genotype to be referenced by the functions of GBScleanR,
# run the following.
gds <- resetCallFilter(gds)

# Reopening the connection to the GDS file also set the raw genotype again.
gds <- loadGDS(gds)

# Close the connection to the GDS file
closeGDS(gds)
}
