% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{countGenotype}
\alias{countGenotype}
\alias{countGenotype,GbsrGenotypeData-method}
\title{Count genotype calls and alleles per sample and per marker.}
\usage{
countGenotype(object, target = "both", node = "raw", ...)

\S4method{countGenotype}{GbsrGenotypeData}(object, target, node)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{target}{Either of "marker" and "sample".}

\item{node}{Either of "raw", "filt", and "cor". See details.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object with genotype count information.
}
\description{
This function calculates several summary statistics of
genotype calls and alleles per marker and per sample.
Those values will be stored in the SnpAnnotaionDataFrame slot
and the \link{sample} slot and obtained via getter
functions, e.g.s
\code{\link[=getCountGenoRef]{getCountGenoRef()}}, \code{\link[=getCountAlleleRef]{getCountAlleleRef()}}, and \code{\link[=getMAF]{getMAF()}}.
}
\details{
#' Genotype call data can be obtained from the "genotype" node,
the "filt.genotype" node, or the "corrected.genotype" node of
the GDS file with \code{node = "raw"}, \code{node = "filt"}, or \code{node = "raw"},
respectively.
The \code{\link[=setCallFilter]{setCallFilter()}} function generate filtered genotype call data in the
"filt.genotype" node which can be accessed as mentioned above.
On the other hand, the "corrected.genotype" node can be generated
via the \code{\link[=estGeno]{estGeno()}} function.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Summarize the genotype count information and store them in the
# [marker] and [sample] slots of the [GbsrGenotypeData] object.
gds <- countGenotype(gds)

# Get the proportion of missing genotype per sample.
sample_missing_rate <- getCountGenoMissing(gds,
                                           target = "sample",
                                           prop = TRUE)

# Get the minor allele frequency per marker.
marker_minor_allele_freq <- getMAF(gds, target = "marker")

# Draw histograms of the missing rate per sample and marker.
histGBSR(gds, stats = "missing")

# Close the connection to the GDS file.
closeGDS(gds)

}
