% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARS_elitism.R
\name{GARS_Elitism}
\alias{GARS_Elitism}
\title{Separate chromosome on the basis of the Fitness Scores}
\usage{
GARS_Elitism(chr.pop, fitn.values, n.elit = 10)
}
\arguments{
\item{chr.pop}{A matrix or a data.frame representing the chromosomes
population: each column is a chromosome and each element corresponds
 to the feature position in the data matrix}

\item{fitn.values}{A numeric vector where each element corresponds to
the fitness score of each chromosome in 'chr.pop'}

\item{n.elit}{The number of best chromosomes to be selected by
elitism. This number must be even. Default is 10}
}
\value{
A list containing:
\itemize{
  \item The population of best chromosomes selected by elitism.
  \item The population of chromosomes not selected by elitism.
  \item The fitness values of best chromosomes selected by elitism.
  \item The fitness values of chromosomes not selected by elitism.
}
}
\description{
This function splits the chromosome population in two
parts allowing the best chromosomes to be preserved from the
"evolutionary" steps: Selection, Crossover and Mutation.
}
\examples{
data(GARS_popul)
data(GARS_Fitness_score)
pop_list <- GARS_Elitism(GARS_popul, GARS_Fitness_score)

}
\seealso{
\code{\link{GARS_Mutation}},
\code{\link{GARS_Selection}},
\code{\link{GARS_Crossover}},
\code{\link{GARS_FitFun}},
}
\author{
Mattia Chiesa, Luca Piacentini
}
