% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchPhenotypeAssociations.R
\name{searchPhenotypeAssociations}
\alias{searchPhenotypeAssociations}
\title{searchPhenotypeAssociations function}
\usage{
searchPhenotypeAssociations(host, phenotypeAssociationSetId,
  featureIds = character(), phenotypeIds = character(), nrows = Inf,
  responseSize = NA_integer_)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{phenotypeAssociationSetId}{Id of the PhenotypeAssociationSet to search.}

\item{featureIds}{Ids of the features. At least one \code{featureId} or
\code{phenotypeId} must be provided.}

\item{phenotypeIds}{Ids of the phenotypes. At least one \code{featureId} or
\code{phenotypeId} must be provided.}

\item{nrows}{Number of rows of the data frame returned by this function.
If not defined, the function will return all entries. If the number of
available entries is less than the value of this this parameter, the function
will silently return only the available entries.}

\item{responseSize}{Specifies the number of entries to be returned by the
server until reach the number of rows defined in \code{nrows} parameter or
until get all available entries. If not defined, the server will return the
allowed maximum reponse size. Increasing this the value of this parameter will
reduce the number of requests and reducing the time required. The will not
respect this parameter if the value if larger than its maximum response size.}
}
\value{
\code{\link{DataFrame}} object. \code{NULL} means no registry found.
}
\description{
This function gets a list of phenotype associations matching the
search criteria.
}
\details{
This function requests to \code{/featurephenotypeassociations/search}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
id <- searchPhenotypeAssociationSets(host, datasetId, nrows = 1)$id
searchPhenotypeAssociations(host, id, nrows = 10)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/genotype_phenotype_service.proto.html#SearchPhenotypeAssociations}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchPhenotypeAssociationSets}}
}
