% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchBiosamples.R
\name{searchBiosamples}
\alias{searchBiosamples}
\title{searchBiosamples function}
\usage{
searchBiosamples(host, datasetId, name = NA_character_,
  individualId = NA_character_, nrows = Inf, responseSize = NA_integer_)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{datasetId}{Id of the dataset to search.}

\item{name}{Returns Biosamples with the given name found by case-sensitive
string matching.}

\item{individualId}{Returns Biosamples for the provided individual ID.}

\item{nrows}{Number of rows of the data frame returned by this function.
If not defined, the function will return all entries. If the number of
available entries is less than the value of this this parameter, the function
will silently return only the available entries.}

\item{responseSize}{Specifies the number of entries to be returned by the
server until reach the number of rows defined in \code{nrows} parameter or
until get all available entries. If not defined, the server will return the
allowed maximum reponse size. Increasing this the value of this parameter will
reduce the number of requests and reducing the time required. The will not
respect this parameter if the value if larger than its maximum response size.}
}
\value{
\code{\link{DataFrame}} object. \code{NULL} means no registry found.
}
\description{
This function gets Biosamples matching the search criteria.
}
\details{
This function requests to \code{/biosamples/search}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
searchBiosamples(host, datasetId, nrows = 10)
}
}
\references{
\href{http://ga4gh-schemas.readthedocs.io/en/latest/schemas/bio_metadata_service.proto.html#SearchBiosamples}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{getBiosample}}
}
