% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFeatureSet.R
\name{getFeatureSet}
\alias{getFeatureSet}
\title{getFeatureSet function}
\usage{
getFeatureSet(host, featureSetId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{featureSetId}{The ID of the FeatureSet to be retrieved.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get a feature set by its ID.
}
\details{
This function requests \code{GET host/featuresets/featureSetId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
featureSetId <- searchFeatureSets(host, datasetId, nrows = 1)$id
getFeatureSet(host, featureSetId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/sequence_annotation_service.proto.html#GetFeatureSet}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchFeatureSets}}
}
