% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadSequence.R
\name{loadSequence}
\alias{loadSequence}
\title{Load Genome Sequences}
\usage{
loadSequence(genome_seq = NULL, seq_path = NULL)
}
\arguments{
\item{genome_seq}{A data frame containing sequence identifiers and
corresponding sequences.}

\item{seq_path}{A character string specifying the file path to a FASTA file
(suffixed with \code{.fa}, \code{.fna} or \code{.fasta}) or a text file with
sequence identifiers and corresponding sequences (file headers should not be
provided). Ignored if \code{genome_seq} is provided.}
}
\value{
A \code{DNAStringSet} object containing the genome sequences.
}
\description{
This function loads genomic sequences from multiple sources, including a
FASTA file, a text file with sequence identifiers and corresponding
sequences, or a data frame object.
}
\examples{

# File path for sequences in fasta format
fa_path <- system.file("extdata", "seq.fa", package = "G4SNVHunter")
seq <- loadSequence(seq_path = fa_path)
print(seq)

# Another example
# Load sequences from data.frame
seq_df <- data.frame(
  chr = c("seq1", "seq2"),
  sequence = c(
    paste0(rep("G", 100), collapse = ""),
    paste0(rep("A", 100), collapse = "")
  )
)
seq <- loadSequence(genome_seq = seq_df)
print(seq)
}
