% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G4SNVImpact.R
\name{filterSNVImpact}
\alias{filterSNVImpact}
\title{Filter SNV Impact GRanges Object Based on User-Defined Thresholds}
\usage{
filterSNVImpact(
  gr,
  raw_score_threshold = NULL,
  mut_score_threshold = NULL,
  score_diff_threshold = NULL
)
}
\arguments{
\item{gr}{A \code{GRanges} object returned by the \code{SNVImpactG4}
function.}

\item{raw_score_threshold}{A positive numeric value no greater than 4 used
as the threshold for the absolute value of \code{G4.info.score}. G4s with
an absolute G4Hunter score exceeding this threshold will be retained.
If \code{NULL}, this threshold is not applied.}

\item{mut_score_threshold}{A positive numeric value no greater than 4 used
as the threshold for the absolute value of \code{mut.score}. Mutated G4s
with an absolute G4Hunter score below this threshold will be retained.
If \code{NULL}, this threshold is not applied.}

\item{score_diff_threshold}{A negative numeric value no less than -4 used as
the threshold for \code{score.diff}. G4s with a decrease in G4Hunter score
greater than this threshold after variation will be retained. If
\code{NULL}, this threshold is not applied.}
}
\value{
A filtered \code{GRanges} object, containing only the records that
meet the specified threshold criteria.
}
\description{
This function is deprecated and will be removed in a future version.
}
\details{
This function filters the SNV Impact \code{GRanges} object returned by the
\code{SNVImpactG4} function based on user-defined thresholds for the
\code{G4.info.score}, \code{mut.score}, and \code{score.diff} parameters.
This function filters SNVs that may significantly impair the formation of G4
structures using customizable filtering criteria. You are not required to
specify all three threshold parameters. However, at least one threshold
parameter must be provided.
}
\section{Deprecated}{

This function is no longer supported.
Use \code{\link{filterVarImpact}} instead.
}

\examples{

if (!requireNamespace("BiocManager", quietly = TRUE)) {
  install.packages("BiocManager")
}

if (!requireNamespace("GenomicRanges", quietly = TRUE)) {
  BiocManager::install("GenomicRanges")
}

if (!requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)) {
  BiocManager::install("BSgenome.Hsapiens.UCSC.hg19")
}

library(GenomicRanges)
library(BSgenome.Hsapiens.UCSC.hg19)

hg19 <- BSgenome.Hsapiens.UCSC.hg19
chr21_seq <- DNAStringSet(hg19$chr21)
# Chromosome name is needed
names(chr21_seq) <- "chr21"

G4 <- G4HunterDetect(chr21_seq)

data(snp_gr)

res_snp <- SNVImpactG4(G4, snp_gr, alt_col = "alt")
filtered_snv_eff <- filterSNVImpact(res_snp,
  mut_score_threshold = 1.2,
  score_diff_threshold = -0.2
)
print(filtered_snv_eff)
}
\seealso{
\code{\link{SNVImpactG4}} for assessing the impact of SNVs on
G4 formation.
}
