% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_metaClustering.R
\name{metaClustering_consensus}
\alias{metaClustering_consensus}
\title{MetaClustering}
\usage{
metaClustering_consensus(data, k = 7, seed = NULL)
}
\arguments{
\item{data}{Matrix containing the data to cluster}

\item{k}{Number of clusters}

\item{seed}{Seed to pass to consensusClusterPlus}
}
\value{
Numeric array indicating cluster for each datapoint
}
\description{
Cluster data using hierarchical consensus clustering with k clusters
}
\examples{
   # Read from file, build self-organizing map and minimal spanning tree
   fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
   flowSOM.res <- ReadInput(fileName, compensate = TRUE,transform = TRUE,
                            scale = TRUE)
   flowSOM.res <- BuildSOM(flowSOM.res,colsToUse = c(9, 12, 14:18))
   flowSOM.res <- BuildMST(flowSOM.res)
   
   # Apply consensus metaclustering
   metacl <- metaClustering_consensus(flowSOM.res$map$codes, k = 10)    

}
\seealso{
\code{\link{MetaClustering}}
}
