% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{test_geneSet}
\alias{test_geneSet}
\title{test_geneSet}
\format{
character vector represent your interesting gene set
}
\usage{
data(test_geneSet)
}
\description{
test_geneSet
}
\examples{
\dontrun{
# source
if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    library(FindIT2)
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))
    ChIP_peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    ChIP_peak_GR <- loadPeakFile(ChIP_peak_path)
    ATAC_peak_path <- system.file("extdata", "ATAC.bed.gz", package = "FindIT2")
    ATAC_peak_GR <- loadPeakFile(ATAC_peak_path)

    mmAnno_geneScan <- mm_geneScan(
        peak_GR = ChIP_peak_GR,
        Txdb = Txdb,
        upstream = 2e4,
        downstream = 2e4
    )

    peakRP_gene <- calcRP_TFHit(
        mmAnno = mmAnno_geneScan,
        Txdb = Txdb,
        report_fullInfo = FALSE
    )

    data("RNADiff_LEC2_GR")
     merge_result <- integrate_ChIP_RNA(
        result_geneRP = peakRP_gene,
        result_geneDiff = RNADiff_LEC2_GR
    )

    target_result <- merge_result$data
    test_geneSet <- target_result$gene_id[1:50]

    related_peaks <- mm_geneBound(
        peak_GR = ATAC_peak_GR,
        Txdb = Txdb,
        input_genes = test_geneSet
    )
    test_featureSet <- unique(related_peaks$feature_id)
    # save(test_geneSet, file = "data/test_geneSet.rda", version = 2)
    # save(test_featureSet, file = "data/test_featureSet.rda", version = 2)
}
}

}
\keyword{datasets}
