% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmPeakAnno_parse.R
\name{plot_peakGeneAlias_summary}
\alias{plot_peakGeneAlias_summary}
\title{plot_peakGeneAlias_summary}
\usage{
plot_peakGeneAlias_summary(
  mmAnno,
  mmAnno_corFilter = NULL,
  output_type = c("gene_id", "feature_id"),
  fillColor = "#ca6b67"
)
}
\arguments{
\item{mmAnno}{the annotated GRange object from mm_geneScan or mm_nearestGene}

\item{mmAnno_corFilter}{the filter mmAnno object according to p-value or cor, defalut is NULL}

\item{output_type}{one of 'gene_id' or 'feature_id'}

\item{fillColor}{the bar plot color}
}
\value{
a ggplot object
}
\description{
plot_peakGeneAlias_summary
}
\examples{
if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))

    peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)
    peakAnno <- mm_nearestGene(peak_GR, Txdb)

    plot_peakGeneAlias_summary(peakAnno)

}
}
