% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakGeneCor.R
\name{enhancerPromoterCor}
\alias{enhancerPromoterCor}
\title{enhancerPromoterCor}
\usage{
enhancerPromoterCor(
  peak_GR,
  Txdb,
  up_scanPromoter = 500,
  down_scanPromoter = 500,
  up_scanEnhancer = 20000,
  down_scanEnhacner = 20000,
  peakScoreMt,
  parallel = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{peak_GR}{peak GRange with a column named feature_id representing you peak name}

\item{Txdb}{Txdb}

\item{up_scanPromoter}{the scan distance which is used to scan nearest promoter}

\item{down_scanPromoter}{the scan distance which is used to scan nearest promoter}

\item{up_scanEnhancer}{the scan distance which is used to scan feature}

\item{down_scanEnhacner}{the scan distance which is used to scan feature}

\item{peakScoreMt}{peak count matrix. The rownames are feature_id in peak_GR}

\item{parallel}{whether you want to parallel to speed up}

\item{verbose}{whether you want to report detailed running message}
}
\value{
mmAnno with Cor, pvalue,padj,qvalue column
}
\description{
enhancerPromoterCor
}
\examples{

if (require(TxDb.Athaliana.BioMart.plantsmart28)){
    data("ATAC_normCount")
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))
    peak_path <- system.file("extdata", "ATAC.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)[1:100]
    mm_ePLink <- enhancerPromoterCor(
    peak_GR = peak_GR,
    Txdb = Txdb,
    peakScoreMt = ATAC_normCount,
    parallel = FALSE)
}


}
