% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcRP.R
\name{calcRP_TFHit}
\alias{calcRP_TFHit}
\title{calcRP_TFHit}
\usage{
calcRP_TFHit(
  mmAnno,
  Txdb,
  decay_dist = 1000,
  report_fullInfo = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{mmAnno}{the annotated GRange object from mm_geneScan}

\item{Txdb}{Txdb}

\item{decay_dist}{decay distance}

\item{report_fullInfo}{whether you want to report full peak-RP-gene info}

\item{verbose}{whether you want to report detailed running message}
}
\value{
if report_fullInfo is TRUE, it will output GRanges with detailed info.
While FALSE, it will output data frame
}
\description{
calculate regulatory potential based on ChIP-Seq peak data, which is useful
for TF ChIP-seq data.
}
\details{
If your origin peak_GR of mmAnno have column named feature_score, calcRP_TFHit
will consider this column when calculating sumRP. Otherwise, it will consider
all peak Hit feature_score is 1.
}
\examples{
if (require(TxDb.Athaliana.BioMart.plantsmart28)){
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))
    peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)
    mmAnno <- mm_geneScan(peak_GR, Txdb)

    # if you just want to get RP_df, you can set report_fullInfo FALSE
    fullRP_hit <- calcRP_TFHit(
        mmAnno = mmAnno,
        Txdb = Txdb,
        report_fullInfo = TRUE
    )

    RP_df <- metadata(fullRP_hit)$peakRP_gene

}
}
