% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{random_qual}
\alias{random_qual}
\title{Create random qualities for a given encoding}
\usage{
random_qual(
  slength,
  swidth,
  qual = NULL,
  encod = c("Sanger", "Illumina1.8", "Illumina1.5", "Illumina1.3", "Solexa"),
  prob = NULL
)
}
\arguments{
\item{slength}{number of sequences}

\item{swidth}{width of the sequences}

\item{qual}{quality range for the sequences. It must be a range included 
in the selected encoding:

'Sanger' = [0, 40]

'Illumina1.8' = [0, 41]

'Illumina1.5' = [0, 40]

'Illumina1.3' = [3, 40]

'Solexa' = [-5, 40]

example: for a range from 20 to 30 in Sanger encoding,
 pass the argument = c(20, 30)}

\item{encod}{sequence encoding}

\item{prob}{a vector of range = range(qual), with probabilities to set 
the frequency of each quality value. Default is equiprobability.
If the sum of the probabilities is > 1, the values will be nomalized 
to the range [0, 1].}
}
\value{
\code{\link[Biostrings:XStringSet-class]{BStringSet}} object
}
\description{
Create a \code{\link[Biostrings:XStringSet-class]{BStringSet}} 
object
with random qualities
}
\examples{

q <- random_qual(30, 20)
q

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
