% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching.R
\name{cutRseq}
\alias{cutRseq}
\alias{cutLseq}
\title{Remove left and right full and partial patterns}
\usage{
cutRseq(
  subject,
  Rpattern,
  with.indels = FALSE,
  fixed = "subject",
  error_rate = 0.2,
  anchored = TRUE,
  ranges = FALSE,
  checks = TRUE,
  min_match_flank = 2L,
  ...
)

cutLseq(
  subject,
  Lpattern,
  with.indels = FALSE,
  fixed = "subject",
  error_rate = 0.2,
  anchored = TRUE,
  ranges = FALSE,
  min_match_flank = 3L,
  checks = TRUE,
  ...
)
}
\arguments{
\item{subject}{\code{\link[Biostrings:DNAString-class]{DNAString}} or 
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}} object}

\item{Rpattern}{3' pattern,
\code{\link[Biostrings:DNAString-class]{DNAString}} object}

\item{with.indels}{Allow indels?}

\item{fixed}{Parameter passed to 
\code{\link[Biostrings]{trimLRPatterns}} 
Default 'subject',  ambiguities in the pattern only are interpreted 
as wildcard. See the argument fixed in 
\code{\link[Biostrings]{trimLRPatterns}}}

\item{error_rate}{Error rate (value in [0, 1]). 
The error rate is the proportion of mismatches allowed between
the adapter and the aligned portion of the subject.
For a given adapter A, the number of allowed mismatches between each 
subsequence s of A and the subject is computed as: error_rate * L_s,
where L_s is the length of the subsequence s.}

\item{anchored}{Can the adapter or partial adapter be within 
the sequence? (anchored = FALSE)
or only in the terminal regions of the sequence? (anchored = TRUE).
Default TRUE (trim only flanking regions)}

\item{ranges}{Return ranges? Default FALSE}

\item{checks}{Perform internal checks? Default TRUE}

\item{min_match_flank}{Do not trim in flanks of the subject,
if a match has min_match_flank of less length. Default 1L 
(only trim with >=2 coincidences in a flank match)}

\item{...}{additional parameters passed to
\code{\link[Biostrings]{trimLRPatterns}}}

\item{Lpattern}{5' pattern,
\code{\link[Biostrings:DNAString-class]{DNAString}} object}
}
\value{
Edited \code{\link[Biostrings:DNAString-class]{DNAString}} or 
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}} object
}
\description{
This set of programs are internal, 
and the function adapter_filter is recommended for trimming. 
The programs can remove adapters and partial 
adapters from 3' and 5'. The adapters can be anchored or not. 
When indels are allowed, the error rate consists in the edit distance. 
IUPAC simbols are allowed. The methods use the 
\code{\link[Biostrings]{trimLRPatterns}} function
 of the \pkg{Biostrings} package, with some additions 
 to take into account e.g., partial adaptors.
 IUPAC symbols are allowed in all the cases. The present function 
also removes partial adapters, without the need of additional steps
 (for example, creating a padded adapter with 'Ns', etc). 
A similar result to the output of \code{\link[Biostrings]{trimLRPatterns}} 
can be obtained with the option anchored = TRUE.
When several matches are found, the function removes the subsequence 
that starts in the first match when cutRseq is used, or ends 
in the last match when cutLseq is used.
}
\examples{
library(Biostrings)

subject <- DNAStringSet(c('ATCATGCCATCATGAT',
'CATGATATTA', 'TCATG', 'AAAAAA', 'AGGTCATG'))

Lpattern <- Rpattern <- 'TCATG'

FastqCleaner:::cutLseq(subject, Lpattern)
FastqCleaner:::cutLseq(subject, Lpattern, ranges = TRUE)
FastqCleaner:::cutRseq(subject, Rpattern)


FastqCleaner:::cutLseq(subject, Lpattern, anchored = FALSE)
FastqCleaner:::cutLseq(subject, Lpattern,  error_rate = 0.2)
FastqCleaner:::cutLseq(subject, Lpattern,  error_rate = 0.2, 
with.indels = TRUE)

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
\keyword{internal}
