% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSimulatedDataset.R
\name{makeSimulatedFraserDataSet}
\alias{makeSimulatedFraserDataSet}
\title{Create an simulated example data set for FRASER}
\usage{
makeSimulatedFraserDataSet(
  m = 100,
  j = 500,
  q = 10,
  distribution = c("BB", "DM"),
  ...
)
}
\arguments{
\item{m}{Number of simulated samples}

\item{j}{Number of simulated junctions}

\item{q}{number of simulated latent variables.}

\item{distribution}{Either "BB" for a beta-binomial simulation or "DM" for a 
dirichlet-multinomial simulation.}

\item{...}{Further arguments used to construct the FraserDataSet.}
}
\value{
An FraserDataSet containing an example dataset based on
        simulated data
}
\description{
Simulates a data set based on random counts following a
beta binomial (or Dirichlet-Multinomial) distribution.
}
\examples{
# A generic dataset
fds1 <- makeSimulatedFraserDataSet()
fds1

# A generic dataset with specificed sample size and injection method
fds2 <- makeSimulatedFraserDataSet(m=10, j=100, q=3)
fds2

}
