% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-SingleCellPipeline.R
\name{SingleCellPipeline}
\alias{SingleCellPipeline}
\title{Pipeline for Single Cell Data}
\usage{
SingleCellPipeline(
  config_file,
  outdir,
  fastq,
  annotation,
  genome_fa,
  genome_mmi,
  minimap2,
  samtools,
  barcodes_file,
  expect_cell_number,
  controllers
)
}
\arguments{
\item{config_file}{Path to the JSON configuration file. See \code{\link{create_config}} for creating one.}

\item{outdir}{Path to the output directory. If it does not exist, it will be created.}

\item{fastq}{Path to the FASTQ file or a directory containing FASTQ files. Each file
will be processed as an individual sample.}

\item{annotation}{The file path to the annotation file in GFF3 / GTF format.}

\item{genome_fa}{The file path to the reference genome in FASTA format.}

\item{genome_mmi}{(optional) The file path to minimap2's index reference genome.}

\item{minimap2}{(optional) The path to the minimap2 binary. If not provided, FLAMES will
use a copy from bioconda via \code{basilisk}.}

\item{samtools}{(optional) The path to the samtools binary. If not provided, FLAMES will
use a copy from bioconda via \code{basilisk}.}

\item{barcodes_file}{The file with expected cell barcodes, with each barcode on a new line.}

\item{expect_cell_number}{The expected number of cells in the sample. This is used if
\code{barcodes_file} is not provided. See \code{BLAZE} for more details.}

\item{controllers}{(optional, \strong{experimental}) A \code{crew_class_controller} object for running certain steps}
}
\value{
A \code{FLAMES.SingleCellPipeline} object. The pipeline can be run using
\code{run_FLAMES(pipeline)}. The results can be accessed with \code{experiment(pipeline)}.
The pipeline also outputs a number of output files into the given \code{outdir} directory.
Some of these output files include:
\describe{
\item{matched_reads.fastq}{ - fastq file with reads demultiplexed}
\item{align2genome.bam}{ - sorted BAM file with reads aligned to genome}
\item{matched_reads_dedup.fastq}{ - demultiplexed and UMI-deduplicated fastq file}
\item{transcript_assembly.fa}{ - transcript sequence from the isoforms}
\item{isoform_annotated.filtered.gff3}{ - isoforms in gff3 format (also contained in the SingleCellExperiment)}
\item{realign2transcript.bam}{ - sorted realigned BAM file using the transcript_assembly.fa as reference}
}
}
\description{
Semi-supervised isofrom detection and annotation for long read data. This variant is
meant for single sample scRNA-seq data. Specific parameters can be configured in
the config file (see \code{\link{create_config}}), input files are specified via
arguments.
}
\details{
By default the pipeline starts with demultiplexing the input fastq data. If the
cell barcodes are known apriori (e.g. via coupled short-read sequencing), the
\code{barcodes_file} argument can be used to specify a file containing the cell
barcodes, and a modified Rcpp version of \code{flexiplex} will be used; otherwise,
\code{expect_cell_number} need to be provided, and \code{BLAZE} will be used to
generate the cell barcodes. The pipeline then aligns the reads to the genome using
\code{minimap2}. The alignment is then used for isoform detection (either using
\code{FLAMES} or \code{bambu}, can be configured). The reads are then realigned
to the detected isoforms. Finally, a transcript count matrix is generated (either
using \code{FLAMES}'s simplistic counting or \code{oarfish}'s Expectation
Maximization algorithm, can be configured). The results can be accssed with
\code{experiment(pipeline)}. If the pipeline errored out / new steps were configured,
it can be resumed by calling \code{resume_FLAMES(pipeline)}
}
\examples{
outdir <- tempfile()
dir.create(outdir)
bc_allow <- file.path(outdir, "bc_allow.tsv")
genome_fa <- file.path(outdir, "rps24.fa")
R.utils::gunzip(
  filename = system.file("extdata", "bc_allow.tsv.gz", package = "FLAMES"),
  destname = bc_allow, remove = FALSE
)
R.utils::gunzip(
  filename = system.file("extdata", "rps24.fa.gz", package = "FLAMES"),
  destname = genome_fa, remove = FALSE
)
ppl <- SingleCellPipeline(
  config_file = create_config(
    outdir,
    pipeline_parameters.demultiplexer = "flexiplex",
    pipeline_parameters.do_gene_quantification = FALSE
  ),
  outdir = outdir,
  fastq = system.file("extdata", "fastq", "musc_rps24.fastq.gz", package = "FLAMES"),
  annotation = system.file("extdata", "rps24.gtf.gz", package = "FLAMES"),
  genome_fa = genome_fa,
  barcodes_file = bc_allow
)
ppl <- run_FLAMES(ppl)
experiment(ppl)

}
\seealso{
\code{\link{create_config}} for creating a configuration file,
\code{\link{BulkPipeline}} for bulk long data,
\code{\link{MultiSampleSCPipeline}} for multi sample single cell pipelines.
}
