% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-.R
\name{getPscores}
\alias{getPscores}
\title{Get p-scores from the desired methodology}
\usage{
getPscores(object, method)
}
\arguments{
\item{object}{FELLA.USER object}

\item{method}{Character, exactly one of: 
\code{"hypergeom"}, \code{"diffusion"}, \code{"pagerank"}}
}
\value{
Named vector of p-scores
}
\description{
Extractor function for the p-scores using the desired methodology
}
\examples{
data(FELLA.sample)
data(input.sample)
obj <- enrich(
compounds = input.sample, 
data = FELLA.sample)
p <- getPscores(obj, "diffusion")
sum(p < 0.1)

}
