% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{subsetRowData}
\alias{subsetRowData}
\alias{subsetRowData<-}
\alias{subsetRowData,SubsetRangedSummarizedExperiment,character-method}
\alias{subsetRowData<-,SubsetRangedSummarizedExperiment,character,DataFrame-method}
\alias{subsetRowData,SubsetSingleCellExperiment,character-method}
\alias{subsetRowData<-,SubsetSingleCellExperiment,character,DataFrame-method}
\alias{subsetRowData<-,SubsetSummarizedExperiment,character,DataFrame-method}
\alias{subsetRowData,SubsetSummarizedExperiment,character-method}
\alias{subsetRowData,SubsetSpatialExperiment,character-method}
\alias{subsetRowData<-,SubsetSpatialExperiment,character,DataFrame-method}
\alias{subsetRowData,SubsetTreeSummarizedExperiment,character-method}
\alias{subsetRowData<-,SubsetTreeSummarizedExperiment,character,DataFrame-method}
\title{Accessor method for rowData from subsets in ExperimentSubset objects}
\usage{
subsetRowData(x, subsetName, parentRowData)

subsetRowData(x, subsetName) <- value

\S4method{subsetRowData}{SubsetRangedSummarizedExperiment,character}(x, subsetName, parentRowData)

\S4method{subsetRowData}{SubsetRangedSummarizedExperiment,character,DataFrame}(x, subsetName) <- value

\S4method{subsetRowData}{SubsetSingleCellExperiment,character}(x, subsetName, parentRowData)

\S4method{subsetRowData}{SubsetSingleCellExperiment,character,DataFrame}(x, subsetName) <- value

\S4method{subsetRowData}{SubsetSummarizedExperiment,character,DataFrame}(x, subsetName) <- value

\S4method{subsetRowData}{SubsetSummarizedExperiment,character}(x, subsetName, parentRowData)

\S4method{subsetRowData}{SubsetSpatialExperiment,character}(x, subsetName, parentRowData)

\S4method{subsetRowData}{SubsetSpatialExperiment,character,DataFrame}(x, subsetName) <- value

\S4method{subsetRowData}{SubsetTreeSummarizedExperiment,character}(x, subsetName, parentRowData)

\S4method{subsetRowData}{SubsetTreeSummarizedExperiment,character,DataFrame}(x, subsetName) <- value
}
\arguments{
\item{x}{\code{ExperimentSubset} Input \code{ExperimentSubset} object.}

\item{subsetName}{\code{character(1)} Name of the subset to set
\code{rowData} to.}

\item{parentRowData}{\code{logical(1)} Logical value indicating if parent
rowData should be combined or not. Default \code{FALSE}.}

\item{value}{Input \code{DataFrame} to store.}
}
\value{
The \code{rowData} from input object.

Input object with \code{rowData} stored.
}
\description{
Get \code{rowData} from a subset.

Set \code{rowData} to a subset.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
subsetRowData(es, "subset1")
}
