% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventPointer_RNASeq_IGV.R
\name{EventPointer_RNASeq_IGV}
\alias{EventPointer_RNASeq_IGV}
\title{EventPointer RNASeq IGV Visualization}
\usage{
EventPointer_RNASeq_IGV(Events, SG_RNASeq, EventsTxt, PathGTF)
}
\arguments{
\item{Events}{Data.frame generated by EventPointer_RNASeq with the events to be included in the GTF file.}

\item{SG_RNASeq}{Output from PrepareBam_EP function. Contains splicing graphs components.}

\item{EventsTxt}{Path to EventsFound.txt file generated with EventDetection function}

\item{PathGTF}{Directory where to write the GTF files.}
}
\value{
The function displays a progress bar to show the user the progress of the function. Once the progress bar reaches 100%, one .gtf
file is written to the specified directory in PathGTF. The created file: 1) paths_RNASeq.gtf : GTF file representing the alternative splicing
events.
}
\description{
Generates of files to be loaded in IGV for visualization and interpretation of events
}
\examples{
\dontrun{
  data(AllEvents_RNASeq)
  data(SG_RNASeq)

   # Run EventPointer

   Dmatrix<-matrix(c(1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1),ncol=2,byrow=FALSE)
   Cmatrix<-t(t(c(0,1)))
   Events <- EventPointer_RNASeq(AllEvents_RNASeq,Dmatrix,Cmatrix,Statistic='LogFC',PSI=TRUE)

   # IGV Visualization

   EventsTxt<-paste(system.file('extdata',package='EventPointer'),'/EventsFound_RNASeq.txt',sep='')
   PathGTF<-tempdir()
   EventPointer_RNASeq_IGV(Events,SG_RNASeq,EventsTxt,PathGTF)
   }
}
