% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventDetection_transcriptome.R
\name{EventDetection_transcriptome}
\alias{EventDetection_transcriptome}
\title{EventDetection_transcriptome}
\usage{
EventDetection_transcriptome(
  inputFile = NULL,
  Transcriptome = NULL,
  Pathtxt = NULL,
  cores = 1
)
}
\arguments{
\item{inputFile}{Path to the GTF file of the reference transcriptome.}

\item{Transcriptome}{Name of the transcriptome}

\item{Pathtxt}{Directory to save the .txt of the events found}

\item{cores}{Number of cores using in the parallel processing (by default = 1)}
}
\value{
a list is returned with the following information:

ExTP1  a sparce matrix of Events x Transcripts that relates which isoform build up the path1 of each event.

ExTP2  a sparce matrix of Events x Transcripts that relates which isoform build up the path2 of each event.

ExTPRef  a sparce matrix of Events x Transcripts that relates which isoform build up the pathRef of each event.

transcritnames  a vector with the annotation names of the isoforms.

SG_List  A list containing the information of the splicing graph of each gene.
}
\description{
Finds all the possible alternative splicing (AS) events given a reference transcriptome. This function use parallel foreach. User must
set the value of cores (by default equal to one). Moreover, it will create a .txt file with the relative information of all the
AS events found. Besides, it will return a list with main information of the splicing graph of each event. This list will be used as an
input in downstream functions (Get_PSI_FromTranRef, FindPrimers, and EventPointer_RNASeq_TranRef_IGV)
}
\examples{

   \dontrun{
         PathFiles<-system.file("extdata",package="EventPointer")
         inputFile <- paste(PathFiles,"/gencode.v24.ann_2genes.gtf",sep="")
         Transcriptome <- "Gencode24_2genes"
         Pathtxt <- tempdir()
         
         
         # Run the function 
         
         EventXtrans <- EventDetection_transcriptome(inputFile = inputFile,
                                                      Transcriptome = Transcriptome,
                                                      Pathtxt=Pathtxt,
                                                      cores=1)
    }

}
