% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventDetection.R
\name{EventDetection}
\alias{EventDetection}
\title{Detect splicing events using EventPointer methodology}
\usage{
EventDetection(Input, cores, Path)
}
\arguments{
\item{Input}{Output of the PrepareBam_EP function}

\item{cores}{Number of cores used for parallel processing}

\item{Path}{Directory where to write the EventsFound_RNASeq.txt file}
}
\value{
list with all the events found for all the genes present in the experiment.
It also generates a file called EventsFound_RNASeq.txt with the information of each event.
}
\description{
Identification of all the alternative splicing events in the splicing graphs
}
\examples{
\dontrun{
  # Run EventDetection function
   data(SG_RNASeq)
   TxtPath<-tempdir()
   AllEvents_RNASeq<-EventDetection(SG_RNASeq,cores=1,Path=TxtPath)
   }

}
