% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/modifications.R,
%   R/modificationsBy.R
\name{modifications}
\alias{modifications}
\alias{modificationsBy}
\alias{modifiedSeqsByTranscript}
\alias{modifications,EpiTxDb-method}
\alias{modificationsBy,EpiTxDb-method}
\alias{modifiedSeqsByTranscript,EpiTxDb,DNAStringSet-method}
\title{Getting modification data from a \code{EpiTxDb-object}}
\usage{
modifications(
  x,
  columns = c("mod_id", "mod_type", "mod_name"),
  filter = NULL,
  use.names = FALSE,
  ...
)

modificationsBy(
  x,
  by = c("seqnames", "mod_type", "reaction", "specifier", "specifier_type"),
  ...
)

modifiedSeqsByTranscript(x, sequences, ...)

\S4method{modifications}{EpiTxDb}(
  x,
  columns = c("mod_id", "mod_type", "mod_name"),
  filter = NULL,
  use.names = FALSE
)

\S4method{modificationsBy}{EpiTxDb}(
  x,
  by = c("seqnames", "modtype", "reaction", "specifier", "specifiertype")
)

\S4method{modifiedSeqsByTranscript}{EpiTxDb,DNAStringSet}(x, sequences)
}
\arguments{
\item{x}{a \code{\link[=EpiTxDb-class]{EpiTxDb}}}

\item{columns}{Columns to include in the result. If the vector is named,
those names are used for the corresponding column in the element metadata
of the returned object. (default: \code{columns =
c("mod_id","mod_type","mod_name")})}

\item{filter}{Either NULL or a named list of vectors to be used to restrict
the output. Valid names for this list are: "mod_id", "mod_type",
"mod_name", "sn_id", "sn_name", "rx_genename", "rx_ensembl",
"rx_ensembltrans", "rx_entrezid", "spec_genename", "spec_type",
"spec_ensembl", "spec_ensembltrans", "spec_entrezid" , "ref_type" and
"ref". (default: \code{filter = NULL})}

\item{use.names}{\code{TRUE} or \code{FALSE}. If \code{TRUE}, the
modification names are set as the names of the returned object. (default:
\code{use.names = FALSE})}

\item{...}{Not used.}

\item{by}{By which information type should the result be split into? A
\code{character} value from one of the following values:
\itemize{
  \item seqnames
  \item mod_type
  \item reaction
  \item specifier
  \item specifier_type
}}

\item{sequences}{A \code{RNAStringSet}, which can be used as input for
\code{\link[Modstrings:separate]{combineIntoModstrings()}}. See
\code{\link[Modstrings:separate]{?combineIntoModstrings}} for additional
details.}
}
\value{
a \code{\link[GenomicRanges:GRanges-class]{GRanges}} object for
  \code{modifications} and a
  \code{\link[GenomicRanges:GRangesList-class]{GRangesList}} for
  \code{modificationsBy}.
}
\description{
\code{modifications} and \code{modificationsBy} are functions to
extract modification annotation from a \code{\link[=EpiTxDb-class]{EpiTxDb}}
object.

\code{modifiedSeqsByTranscript} returns a
\code{\link[Modstrings:ModStringSet]{ModRNAStringSet}} from a \code{EpiTxDb}
object and compatible \code{RNAStringSet} object. This used the
\code{\link[Modstrings:separate]{combineIntoModstrings()}} function from the
\code{Modstrings} package.
}
\examples{
etdb_file <- system.file("extdata", "EpiTxDb.Hs.hg38.snoRNAdb.sqlite",
                        package="EpiTxDb")
etdb <- loadDb(etdb_file)
etdb
}
