% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetNearbyGenes.R
\name{getRegionNearGenes}
\alias{getRegionNearGenes}
\title{Identifies nearest genes to a region}
\usage{
getRegionNearGenes(
  TRange = NULL,
  numFlankingGenes = 20,
  geneAnnot = NULL,
  tssAnnot = NULL
)
}
\arguments{
\item{TRange}{A GRange object contains coordinate of targets.}

\item{numFlankingGenes}{A number determine how many gene will be collected from each}

\item{geneAnnot}{A GRange object contains gene coordinates of for human genome.}

\item{tssAnnot}{A GRange object contains tss coordinates of for human genome.}
}
\value{
A data frame of nearby genes and information: genes' IDs, genes' symbols,
}
\description{
Auxiliary function for GetNearGenes
 This will get the closest genes (n=numFlankingGenes) for a target region (TRange)
 based on a genome of refenrece gene annotation (geneAnnot). If the
 transcript level annotation (tssAnnot) is provided the Distance will be updated to
 the distance to the nearest TSS.
}
\author{
Tiago C Silva (maintainer: tiagochst@usp.br)
}
