% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{functionEnrich}
\alias{functionEnrich}
\title{The functionEnrich function}
\usage{
functionEnrich(
  EpiMixResults,
  methylation.state = "all",
  enrich.method = "GO",
  ont = "BP",
  simplify = TRUE,
  cutoff = 0.7,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  qvalueCutoff = 0.2,
  save.dir = "."
)
}
\arguments{
\item{EpiMixResults}{List of the result objects returned from the EpiMix function.}

\item{methylation.state}{character string indicating whether to use all the differentially methylated genes or only use the hypo- or hyper-methylated genes for enrichment analysis. Can be either 'all', 'Hyper' or 'Hypo'.}

\item{enrich.method}{character string indicating the method to perform enrichment analysis, can be either 'GO' or 'KEGG'.}

\item{ont}{character string indicating the aspect for GO analysis. Can be one of 'BP' (i.e., biological process), 'MF' (i.e., molecular function), and 'CC' (i.e., cellular component) subontologies, or 'ALL' for all three.}

\item{simplify}{boolean value indicating whether to remove redundancy of enriched GO terms.}

\item{cutoff}{if simplify is TRUE, this is the threshold for similarity cutoff of the ajusted p value.}

\item{pvalueCutoff}{adjusted pvalue cutoff on enrichment tests to report}

\item{pAdjustMethod}{one of 'holm', 'hochberg', 'hommel', 'bonferroni', 'BH', 'BY', 'fdr', 'none'}

\item{qvalueCutoff}{qvalue cutoff on enrichment tests to report as significant. Tests must pass i) pvalueCutoff on unadjusted pvalues, ii) pvalueCutoff on adjusted pvalues and iii) qvalueCutoff on qvalues to be reported.}

\item{save.dir}{path to save the enrichment table.}
}
\value{
a clusterProfiler enrichResult instance
}
\description{
Perform functional enrichment analysis for the differentially methylated genes occurring in the significant CpG-gene pairs.
}
\examples{
\donttest{
library(clusterProfiler)
library(org.Hs.eg.db)

data(Sample_EpiMixResults_Regular)

enrich.results <- function.enrich(
 EpiMixResults = Sample_EpiMixResults_Regular,
 enrich.method = 'GO',
 ont = 'BP',
 simplify = TRUE,
 save.dir = ''
)
}

}
