% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO_Download_Preprocess.R
\name{GEO_Download_GeneExpression}
\alias{GEO_Download_GeneExpression}
\title{The GEO_Download_GeneExpression function}
\usage{
GEO_Download_GeneExpression(
  AccessionID,
  targetDirectory = ".",
  DownloadData = TRUE
)
}
\arguments{
\item{AccessionID}{character string indicating the GEO accession number. Currently support the GEO series (GSE) data type.}

\item{targetDirectory}{character string indicting the file path to save the data. Default: '.' (current directory)}

\item{DownloadData}{logical indicating whether the actual data should be downloaded (Default: TRUE). If False, the desired directory where the downloaded data should have been saved is returned.}
}
\value{
a list with two elements. The first element ('$GeneExpressionData') indicating the file path to the downloaded methylation data. The second element ('$PhenotypicData') indicating the file path to the sample phenotypic data.
}
\description{
Download the gene expression data and the associated sample phenotypic data from the GEO database.
}
\examples{
\donttest{
GEdirectories <- GEO_Download_GeneExpression(AccessionID = 'GSE114065',
                                             targetDirectory = tempdir())
}
}
\keyword{download}
