% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComBat_NoFiles.R
\name{ComBat_NoFiles}
\alias{ComBat_NoFiles}
\title{The ComBat_NoFiles function}
\usage{
ComBat_NoFiles(
  dat,
  saminfo,
  type = "txt",
  write = FALSE,
  covariates = "all",
  par.prior = FALSE,
  filter = FALSE,
  skip = 0,
  prior.plots = TRUE
)
}
\arguments{
\item{dat}{dat}

\item{saminfo}{saminfo}

\item{type}{currently supports two data file types 'txt' for a tab-delimited text file and 'csv' for an Excel .csv file (sometimes R handles the .csv file better, so use this if you have problems with a .txt file!).}

\item{write}{if 'T' ComBat writes adjusted data to a file, and if 'F' and ComBat outputs the adjusted data matrix if 'F' (so assign it to an object! i.e. NewData <- ComBat('my expression.xls','Sample info file.txt', write=F)).}

\item{covariates}{'covariates=all' will use all of the columns in your sample info file in the modeling (except array/sample name), if you only want use a some of the columns in your sample info file, specify these columns here as a vector (you must include the Batch column in this list).}

\item{par.prior}{if 'T' uses the parametric adjustments, if 'F' uses the nonparametric adjustments--if you are unsure what to use, try the parametric adjustments (they run faster) and check the plots to see if these priors are reasonable.}

\item{filter}{'filter=value' filters the genes with absent calls in > 1-value of the samples. The defaut here (as well as in dchip) is .8.
Filter if you can as the EB adjustments work better after filtering.
Filter must be numeric if your expression index file contains presence/absence calls (but you can set it >1 if you don't want to filter any genes) and must be 'F' if your data doesn't have presence/absence calls;}

\item{skip}{is the number of columns that contain probe names and gene information, so 'skip=5' implies the first expression values are in column 6}

\item{prior.plots}{if true will give prior plots with black as a kernal estimate of the empirical batch effect density and red as the parametric estimate.}
}
\value{
Results.
}
\description{
Internal. Performs batch correction.
}
\keyword{internal}
