% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_upset_plot.R
\name{overlap_upset_plot}
\alias{overlap_upset_plot}
\title{Generate Upset plot for overlapping peaks}
\usage{
overlap_upset_plot(peaklist, verbose = TRUE)
}
\arguments{
\item{peaklist}{A named list of peak files as GRanges object.
Objects must be listed and named using \code{list()}.
e.g. \code{list("name1"=file1, "name2"=file2)}.
If not named, default file names are assigned.}

\item{verbose}{Print messages}
}
\value{
Upset plot of overlapping peaks.
}
\description{
This function generates upset plot of overlapping peaks files
using the 
\href{https://cran.r-project.org/web/packages/ComplexUpset}{
\pkg{ComplexUpset}} package.
}
\examples{
### Load Data ###
data("encode_H3K27ac") # load example data
data("CnT_H3K27ac") # load example data 
peaklist <- list("encode"=encode_H3K27ac, "CnT"=CnT_H3K27ac) 
my_plot <- overlap_upset_plot(peaklist = peaklist)
}
