% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_percent.R
\name{overlap_percent}
\alias{overlap_percent}
\title{Calculate percentage of overlapping peaks}
\usage{
overlap_percent(
  peaklist1,
  peaklist2,
  invert = FALSE,
  precision_recall = TRUE,
  suppress_messages = TRUE
)
}
\arguments{
\item{peaklist1}{A list of peak files as GRanges object.
Files must be listed and named using \code{list()}.
e.g. \code{list("name1"=file1, "name2"=file2)}.
If not named, default file names will be assigned.}

\item{peaklist2}{peaklist1 A list of peak files as GRanges object.
Files must be listed and named using \code{list()}.
e.g. \code{list("name1"=file1, "name2"=file2)}.}

\item{invert}{
    If \code{TRUE}, keep only the ranges in \code{x} that do \emph{not}
    overlap \code{ranges}.
  }

\item{precision_recall}{Return percision-recall results for all combinations 
of \code{peaklist1} (the "query") and \code{peaklist2} (the "subject"). 
See \link[IRanges]{subsetByOverlaps} for more details on this terminology.}

\item{suppress_messages}{Suppress messages.}
}
\value{
data frame
}
\description{
This function calculates the percentage of overlapping peaks and outputs
a table or matrix of results.
}
\examples{
### Load Data ###
data("encode_H3K27ac") # example peakfile GRanges object
data("CnT_H3K27ac") # example peakfile GRanges object
data("CnR_H3K27ac") # example peakfile GRanges object

### Create Named Peaklist ###
peaks <- list("CnT"=CnT_H3K27ac, "CnR"=CnR_H3K27ac)
reference_peak <- list("ENCODE"=encode_H3K27ac)

### Run ###
overlap <- overlap_percent(peaklist1=peaks,
                           peaklist2=reference_peak)
}
