% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_consensus_peaks.R
\name{compute_consensus_peaks}
\alias{compute_consensus_peaks}
\title{Compute consensus peaks}
\source{
\href{https://ro-che.info/articles/2018-07-11-chip-seq-consensus}{
GenomicRanges tutorial}

\href{https://doi.org/doi:10.18129/B9.bioc.consensusSeekeR}{
consensusSeekeR}
}
\usage{
compute_consensus_peaks(
  grlist,
  groups = NULL,
  genome_build,
  lower = 2,
  upper = Inf,
  min.gapwidth = 1L,
  method = c("granges", "consensusseeker"),
  ...
)
}
\arguments{
\item{grlist}{Named list of \link[GenomicRanges]{GRanges} objects.}

\item{groups}{A character vector of the same length as \code{grlist} 
defining how to group \link[GenomicRanges]{GRanges} objects when 
computing consensus peaks.}

\item{genome_build}{Genome build name.}

\item{lower, upper}{
    The lower and upper bounds for the slice.
  }

\item{min.gapwidth}{
    Ranges separated by a gap of at least \code{min.gapwidth} positions
    are not merged.
  }

\item{method}{Method to call peaks with:
\itemize{
\item{"granges" : }{Simple overlap procedure using 
\link[GenomicRanges]{GRanges} functions.
Faster but less accurate.}
\item{"consensusseeker" : }{
Uses \link[consensusSeekeR]{findConsensusPeakRegions} to compute consensus
peaks. 
Slower but more accurate.}
}}

\item{...}{
  Arguments passed on to \code{\link[consensusSeekeR:findConsensusPeakRegions]{consensusSeekeR::findConsensusPeakRegions}}
  \describe{
    \item{\code{narrowPeaks}}{a \code{GRanges} containing
called peak regions of signal enrichment based on pooled, normalized data
for all analyzed experiments. All \code{GRanges} entries must
have a metadata field called "name" which identifies the region to
the called peak. All \code{GRanges} entries must also
have a row name which identifies the experiment of origin. Each
\code{peaks} entry must have an associated \code{narrowPeaks} entry.
A \code{GRanges} entry is associated to a \code{narrowPeaks} entry by
having a identical metadata "name" field and a identical row name.}
    \item{\code{peaks}}{a \code{GRanges} containing called peaks of signal
enrichment based on pooled, normalized data
for all analyzed experiments. All \code{GRanges} entries must
have a metadata field called "name" which identifies the called
peak. All \code{GRanges} entries must
have a row name which identifies the experiment of origin. Each
\code{peaks} entry must have an associated \code{narrowPeaks} entry. A
\code{GRanges} entry is associated to a \code{narrowPeaks} entry by having
a identical metadata "name" field and a identical row name.}
    \item{\code{chrInfo}}{a \code{Seqinfo} containing the name and the length of the
chromosomes to analyze. Only the chomosomes contained in this
\code{Seqinfo} will be analyzed.}
    \item{\code{extendingSize}}{a \code{numeric} value indicating the size of padding
on both sides of the position of the peaks median to create the
consensus region. The minimum size of the consensus region is
equal to twice the value of the \code{extendingSize} parameter.
The size of the \code{extendingSize} must be a positive integer.
Default = 250.}
    \item{\code{expandToFitPeakRegion}}{a \code{logical} indicating if the region size,
which is set by the \code{extendingSize} parameter is extended to include
the entire narrow peak regions of all peaks included in the unextended
consensus region. The narrow peak regions of the peaks added because of the
extension are not considered for the extension. Default: \code{FALSE}.}
    \item{\code{shrinkToFitPeakRegion}}{a \code{logical} indicating if the region size,
which is set by the \code{extendingSize} parameter is shrinked to
fit the narrow peak regions of the peaks when all those regions
are smaller than the consensus region. Default: \code{FALSE}.}
    \item{\code{minNbrExp}}{a positive \code{numeric} or a positive \code{integer}
indicating the minimum number of experiments in which at least one peak
must be present for a potential consensus region. The numeric must be a
positive integer inferior or equal to the number of experiments present
in the \code{narrowPeaks} and \code{peaks} parameters. Default = 1.}
    \item{\code{nbrThreads}}{a \code{numeric} or a \code{integer} indicating the
number of threads to use in parallel. The \code{nbrThreads} must be a
positive integer. Default = 1.}
  }}
}
\value{
Named list of consensus peak \link[GenomicRanges]{GRanges}.
}
\description{
Compute consensus peaks from a list of \link[GenomicRanges]{GRanges}.
}
\details{
\emph{NOTE:} If you get the error 
\code{"Error in serialize(data, node$con) : error writing to connection"},
try running \link[base]{closeAllConnections} 
and rerun \link[EpiCompare]{compute_consensus_peaks}. 
This error can sometimes occur when 
\link[EpiCompare]{compute_consensus_peaks}
has been disrupted partway through.
}
\examples{
data("encode_H3K27ac") # example dataset as GRanges object
data("CnT_H3K27ac") # example dataset as GRanges object
data("CnR_H3K27ac") # example dataset as GRanges object 
grlist <- list(CnR=CnR_H3K27ac, CnT=CnT_H3K27ac, ENCODE=encode_H3K27ac)

consensus_peaks <- compute_consensus_peaks(grlist = grlist,
                                           groups = c("Imperial",
                                                      "Imperial",
                                                      "ENCODE"))
}
