% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_process_methylation.R
\name{pre_process_methylation}
\alias{pre_process_methylation}
\title{Preprocess the Beta value matrix}
\usage{
pre_process_methylation(met,Mvalue,constant_offset,remove_na,remove_percentage)
}
\arguments{
\item{met}{methylation matrix for CpGs. Rows are the CpG names, columns are samples.}

\item{Mvalue}{Boolean value, TRUE for the M transformation.}

\item{constant_offset}{the constant offset used in the M transformation formula.}

\item{remove_na}{Boolean value, if TRUE ,CpGs with NA values will be removed.}

\item{remove_percentage}{If precentage of NA value exceed the threshold(percentage), the whole CpG probe will be removed. Otherwise, the NA values are replaced with rowmeans.}
}
\value{
Object of class \code{matrix}.
}
\description{
This process is optional for the pipeline.
This function pre-process the Beta matrix and transform the Beta value into M value.
}
\examples{
demo_set<-create_demo()
pre_process_methylation(demo_set,Mvalue=FALSE)

}
