% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_prediction.R
\name{ensemble_prediction}
\alias{ensemble_prediction}
\title{fitting function using stacking ensemble model for Methylation Correlation Block}
\usage{
ensemble_prediction(ensemble_model, prediction_data, multiple_results = FALSE)
}
\arguments{
\item{ensemble_model}{ensemble model which built by ensemble_model() function}

\item{prediction_data}{A vector, matrix, list, or data frame containing the predictions (input).}

\item{multiple_results}{Boolean vector, True for including the single model results.}
}
\value{
Object of numeric class \code{double}
}
\description{
predict is a generic function for predictions from the results of stacking ensemble model fitting functions.
The function invokes particular methods which is the ensemble model described in the reference.
}
\examples{
library(survival)
#import datasets
data(demo_survival_data)
datamatrix<-create_demo()
data(demo_MCBinformation)
#select MCB with at least 3 CpGs.
demo_MCBinformation<-demo_MCBinformation[demo_MCBinformation[,"CpGs_num"]>2,]
trainingset<-colnames(datamatrix) \%in\% sample(colnames(datamatrix),0.6*length(colnames(datamatrix)))
testingset<-!trainingset
#select one MCB
select_single_one=1
em<-ensemble_model(t(demo_MCBinformation[select_single_one,]),
    training_set=datamatrix[,trainingset],
    Surv_training=demo_survival_data[trainingset])

em_prediction_results<-ensemble_prediction(ensemble_model = em,
prediction_data = datamatrix[,testingset])

}
\references{
Xin Yu et al. 2019 Predicting disease progression in lung adenocarcinoma patients based on methylation correlated blocks using ensemble machine learning classifiers (under review)
}
