% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_genesize_control_network.r
\name{prepare_genesize_control_network}
\alias{prepare_genesize_control_network}
\title{Prepare genesize control network}
\usage{
prepare_genesize_control_network(
  hits,
  bg = NULL,
  reps = 10000,
  no_cores = 1,
  sctSpecies = NULL,
  genelistSpecies = NULL,
  verbose = TRUE,
  localHub = FALSE
)
}
\arguments{
\item{hits}{List of gene symbols containing the target gene list.
Will automatically be converted to human gene symbols
if \code{geneSizeControl=TRUE}.}

\item{bg}{List of gene symbols containing the background gene list
(including hit genes). If \code{bg=NULL},
 an appropriate gene background will be created automatically.}

\item{reps}{Number of gene lists to sample.}

\item{no_cores}{Number of cores to parallelise
bootstrapping \code{reps} over.}

\item{sctSpecies}{Species that \code{sct_data} is currently formatted as
(no longer limited to just "mouse" and "human").
See \link[EWCE]{list_species} for all available species.}

\item{genelistSpecies}{Species that \code{hits} genes came from
(no longer limited to just "mouse" and "human").
See \link[EWCE]{list_species} for all available species.}

\item{verbose}{Print messages.}

\item{localHub}{If working offline, add argument localHub=TRUE to work 
with a local, non-updated hub; It will only have resources available that
have previously been downloaded. If offline, Please also see BiocManager
vignette section on offline use to ensure proper functionality.}
}
\value{
A list containing three data frames:
\itemize{
  \item \code{hits}: Array of HGNC symbols containing the hit genes.
  May be slightly reduced if gene length / GC content could not be found
  for all genes.
  \item \code{list_network}: The control gene lists as a data frame of HGNC
  symbols
}
}
\description{
\code{prepare_genesize_control_network} takes a gene list and finds
semi-randomly selected gene lists which are matched for gene length and
GC content.
}
\keyword{internal}
