% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_bootstrap_plots.r
\name{generate_bootstrap_plots}
\alias{generate_bootstrap_plots}
\title{Generate bootstrap plots}
\usage{
generate_bootstrap_plots(
  sct_data = NULL,
  hits = NULL,
  bg = NULL,
  genelistSpecies = NULL,
  sctSpecies = NULL,
  output_species = "human",
  method = "homologene",
  reps = 100,
  annotLevel = 1,
  geneSizeControl = FALSE,
  full_results = NULL,
  listFileName = paste0("_level", annotLevel),
  adj_pval_thresh = 0.05,
  facets = "CellType",
  scales = "free_x",
  save_dir = file.path(tempdir(), "BootstrapPlots"),
  show_plot = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{sct_data}{List generated using \link[EWCE]{generate_celltype_data}.}

\item{hits}{List of gene symbols containing the target gene list.
Will automatically be converted to human gene symbols
if \code{geneSizeControl=TRUE}.}

\item{bg}{List of gene symbols containing the background gene list
(including hit genes). If \code{bg=NULL},
 an appropriate gene background will be created automatically.}

\item{genelistSpecies}{Species that \code{hits} genes came from
(no longer limited to just "mouse" and "human").
See \link[EWCE]{list_species} for all available species.}

\item{sctSpecies}{Species that \code{sct_data} is currently formatted as
(no longer limited to just "mouse" and "human").
See \link[EWCE]{list_species} for all available species.}

\item{output_species}{Species to convert \code{sct_data} and \code{hits} to
(Default: "human").
See \link[EWCE]{list_species} for all available species.}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{reps}{Number of random gene lists to generate (\emph{Default: 100},
but should be >=10,000 for publication-quality results).}

\item{annotLevel}{An integer indicating which level of \code{sct_data} to
analyse (\emph{Default: 1}).}

\item{geneSizeControl}{Whether you want to control for
GC content and transcript length. Recommended if the gene list originates
from genetic studies (\emph{Default: FALSE}).
If set to \code{TRUE}, then \code{hits} must be from humans.}

\item{full_results}{The full output of
\link[EWCE]{bootstrap_enrichment_test} for the same gene list.}

\item{listFileName}{String used as the root for files saved using this
function.}

\item{adj_pval_thresh}{Adjusted p-value threshold of celltypes to include
in plots.}

\item{facets}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{rows}
and \code{cols} instead.}

\item{scales}{Are scales shared across all facets (the default,
\code{"fixed"}), or do they vary across rows (\code{"free_x"}),
columns (\code{"free_y"}), or both rows and columns (\code{"free"})?}

\item{save_dir}{Directory where the BootstrapPlots folder should be saved,
default is a temp directory.}

\item{show_plot}{Print the plot.}

\item{verbose}{Print messages.}
}
\value{
Saves a set of pdf files containing graphs and returns the file where
they are saved. These will be saved with the file name adjusted using the
value of \code{listFileName}. The files are saved into the 
'BootstrapPlot' folder.
Files start with one of the following:
\itemize{
  \item \code{qqplot_noText}: sorts the gene list according to how enriched
  it is in the relevant cell type. Plots the value in the target list against
  the mean value in the bootstrapped lists.
  \item \code{qqplot_wtGSym}: as above but labels the gene symbols for the
  highest expressed genes.
  \item \code{bootDists}: rather than just showing the mean of the
  bootstrapped lists, a boxplot shows the distribution of values
  \item \code{bootDists_LOG}: shows the bootstrapped distributions with the
  y-axis shown on a log scale
}
}
\description{
\code{generate_bootstrap_plots} takes a gene list and a single cell type
transcriptome dataset and generates plots which show how the expression of
the genes in the list compares to those in randomly generated gene lists.
}
\examples{
## Load the single cell data
sct_data <- ewceData::ctd()

## Set the parameters for the analysis
## Use 5 bootstrap lists for speed, for publishable analysis use >10000
reps <- 5

## Load the gene list and get human orthologs
hits <- ewceData::example_genelist()

## Bootstrap significance test,
##  no control for transcript length or GC content
## Use pre-computed results to speed up example
full_results <- EWCE::example_bootstrap_results()

### Skip this for example purposes
# full_results <- EWCE::bootstrap_enrichment_test(
#    sct_data = sct_data,
#    hits = hits,
#    reps = reps,
#    annotLevel = 1,
#    sctSpecies = "mouse",
#    genelistSpecies = "human"
# )

output <- EWCE::generate_bootstrap_plots(
    sct_data = sct_data,
    hits = hits,
    reps = reps,
    full_results = full_results,
    sctSpecies = "mouse",
    genelistSpecies = "human",
    annotLevel = 1
)
}
