% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_specificity_into_quantiles.r
\name{bin_specificity_into_quantiles}
\alias{bin_specificity_into_quantiles}
\title{bin_specificity_into_quantiles}
\usage{
bin_specificity_into_quantiles(
  ctdIN,
  numberOfBins,
  matrix_name = "specificity_quantiles",
  as_sparse = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{ctdIN}{A single annotLevel of a ctd, i.e. \code{ctd[[1]]} 
(the function is intended to be used via \code{apply}).}

\item{numberOfBins}{Number of quantile 'bins' to use (40 is recommended).}

\item{matrix_name}{Name of the specificity matrix to create 
(default: "specificity_quantiles").}

\item{as_sparse}{Convert to sparseMatrix.}

\item{verbose}{Print messages.}
}
\value{
A ctd with "specificity_quantiles" matrix in each level 
(or whatever \code{matrix_name} was set to.).
}
\description{
\code{bin_specificity_into_quantiles} is an internal function used to convert
add '$specificity_quantiles' to a ctd
}
\examples{
ctd <- ewceData::ctd()
ctd <- lapply(ctd, EWCE::bin_specificity_into_quantiles, numberOfBins = 40)
print(ctd[[1]]$specificity_quantiles[1:3, ])
}
