#' Fix celltype name in full results
#'
#' Aligns celltype names in full results generated by
#' \link[EWCE]{bootstrap_enrichment_test} with the standardised
#' CellTypeDataset (CTD) produced by \link[EWCE]{standardise_ctd}.
#'
#' @param full_results Cell-type enrichment results generated by
#' \link[EWCE]{bootstrap_enrichment_test}.
#' @param verbose Print messages.
#'
#' @return Fixed full results.
#'
#' @keywords internal
fix_celltype_names_full_results <- function(full_results,
                                            verbose = TRUE) { 
    if(all(is.na(full_results))) return(NA)
    if(is.null(full_results)) return(NULL)
    
    messager("Aligning celltype names with standardise_ctd format.",
             v = verbose
    )
    rownames(full_results$results) <- fix_celltype_names(
        rownames(full_results$results)
    )
    full_results$results$CellType <- fix_celltype_names(
        full_results$results$CellType
    )
    names(full_results$hit.cells) <- fix_celltype_names(
        names(full_results$hit.cells)
    )
    colnames(full_results$bootstrap_data) <- fix_celltype_names(
        colnames(full_results$bootstrap_data)
    )
    return(full_results)
}
