% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_intersectPlot.R
\name{ggplot2_intersectPlot}
\alias{ggplot2_intersectPlot}
\title{Plot number of DE genes that is common across combinations}
\usage{
ggplot2_intersectPlot(deg = NULL, path = ".", save_plot = TRUE)
}
\arguments{
\item{deg}{The list of DE genes generated by one of ERSSA::DE_*.R scripts.}

\item{path}{Path to which the plot will be saved. Default to current working
directory.}

\item{save_plot}{Boolean. Whether to save plot to drive. Default to TRUE.}
}
\value{
A list is returned containing:
 \itemize{
  \item{gg_object} {the ggplot2 object, which can then be further
  customized.}
  \item{intersect.dataframe} {the tidy table version used for plotting.}
  \item{deg_dataframe} {the tidy table version of DEG numbers for
  plotting mean.}
  \item{intersect_genes} {list of vectors containing DE genes with vector
  name indicating the associated replicate level.}
  \item{full_num_DEG} {The number of DE genes with all samples included.}
}
}
\description{
\code{ggplot2_intersectPlot} function generates and plots the list of
differentially expressed (DE) genes that are found in all
combinations at any particular replicate level. Often in small-scale
RNA-seq experiments, the inclusion or exclusion of any paricular sample can
result in a very different list of DE genes. To reduce the influence of any
particular sample in the entire dataset analysis, it may be desirable to
identify the list of DE genes that are enriched regardless of any specific
sample(s) inclusion. This approach may be most useful analyzing the list of
common DE genes at the greatest possible replicate to take advantage of the
robust feature as well as employing typically the longest list of DE genes.
}
\details{
Similar to how increasing number of detected DE genes can be found with more
biological replicates, the list of common DE genes is expected to increase
with more replicates. This eventually levels off as majority of DE genes have
been found.
}
\examples{
# load edgeR deg object generated by erssa_edger using example dataset
# example dataset containing 1000 genes, 4 replicates and 5 comb. per rep.
# level
data(deg.partial, package = "ERSSA")

gg_intersect = ggplot2_intersectPlot(deg.partial)

}
\references{
H. Wickham. ggplot2: Elegant Graphics for Data Analysis.
Springer-Verlag New York, 2009.
}
\author{
Zixuan Shao, \email{Zixuanshao.zach@gmail.com}
}
