% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CVM.R
\name{calculate_cvm_gene}
\alias{calculate_cvm_gene}
\title{Calculate CVM score for a single gene}
\usage{
calculate_cvm_gene(vec, outcomes, sample_names)
}
\arguments{
\item{vec}{A named vector containing data (e.g. expression data) for a single
gene.}

\item{outcomes}{A vector of group labels for the samples. The names must correspond
to the names of \code{vec}.}

\item{sample_names}{A character vector with the names of the samples in \code{vec}.}
}
\value{
The cvm score is returned.
}
\description{
Calculate CVM score for a single gene
}
\details{
All possible combinations of the classes are used as pairwise comparisons.
The data in \code{vec} is divided based on class labels based on the \code{outcomes}
identifiers given. For each pairwise computation, the \code{\link{hist}} function is
used to generate histograms for the two groups. The densities are then retrieved
and passed to  \code{\link[CDFt]{CramerVonMisesTwoSamples}} to compute the pairwise CVM score. The
total CVM score for the given data is the average of the pairwise CVM scores.
}
\examples{
# 100 genes, 100 samples
dat <- matrix(rnorm(10000), nrow=100, ncol=100)
rownames(dat) <- paste("gene", 1:100, sep="")
colnames(dat) <- paste("sample", 1:100, sep="")

# "A": first 50 samples; "B": next 30 samples; "C": final 20 samples
outcomes <- c(rep("A",50), rep("B",30), rep("C",20))
names(outcomes) <- colnames(dat)

calculate_cvm_gene(dat[1,], outcomes, colnames(dat))
}
\seealso{
\code{\link[CDFt]{CramerVonMisesTwoSamples}}
}

