% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_degree.R
\name{node_degree}
\alias{node_degree}
\title{Calculate node degree}
\usage{
node_degree(net)
}
\arguments{
\item{net}{numeric matrix}
}
\value{
node_degree numeric array
}
\description{
The function calculates the node degree of a network
}
\examples{
net <- cor( matrix(rnorm(1000), ncol=10)) 
n <- 10
net <- matrix(rank(net, na.last = 'keep', ties.method = 'average'), nrow = n, ncol = n)
net <- net/max(net, na.rm=TRUE)
nd <- node_degree(net)
 
}
\keyword{degree}
\keyword{metric}
\keyword{network}
\keyword{node}
\keyword{topology}
