% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_orthologs.R
\name{filter_orthologs}
\alias{filter_orthologs}
\title{Filter on orthologs}
\usage{
filter_orthologs(annotations, genelist, orthologs)
}
\arguments{
\item{annotations}{binary matrix}

\item{genelist}{array of gene ids}

\item{orthologs}{array to filter on}
}
\value{
annotations_filtered binary matrix
}
\description{
The function filters away the labels for the genes 
that are not in the orthologs list
}
\examples{
genes.labels <- matrix( sample( c(0,1), 1000, replace=TRUE), nrow=100)
rownames(genes.labels) = paste('gene', 1:100, sep='')
colnames(genes.labels) = paste('function', 1:10, sep='')
gene.list <- paste('gene', 1:100, sep='')
orthologs <- paste('gene', (1:50)*2, sep='')
genes.labels.filt <- filter_orthologs(genes.labels, gene.list, orthologs) 

}
\keyword{annotations}
\keyword{filter}
\keyword{orthologs}
