\name{priorDiagnostic}
\alias{priorDiagnostic}
\title{Visual diagnostic for the EBcoexpress prior}
\description{
A visual diagnostic used to check the prior estimated by an
ebCoexpressSeries function against the data using the prior
predictive distribution specified by the EBcoexpress model.
The function compares the empirical prior predictive distribution of the
(transformed) correlations in one condition against the theoretical
prior predictive distribution
}
\usage{
priorDiagnostic(D, conditions, ebOutObj, focusCond, seed = NULL, colx = "red", applyTransform = TRUE, subsize = NULL, ...)
}
\arguments{
  \item{D}{
The correlation matrix output of makeMyD()
}
  \item{conditions}{
The conditions array
}
  \item{ebOutObj}{
The structured list output from an ebCoexpressSeries function
}
  \item{focusCond}{
A condition whose correlations will be used in the diagnostic. We suggest
running the diagnostic for each condition, one at a time
}
  \item{seed}{
A seed for making the subsize subselection deterministic; has no effect
if subsize= is left NULL
}
  \item{colx}{
A color for the fitted marginal distribution. Defaults to red
}
  \item{applyTransform}{
Should Fisher's Z-transformation be applied? Defaults to TRUE
}
  \item{subsize}{
If non-NULL, a value less than the 1st dimension of D (p).
The diagnostic will use subsize randomly chosen correlations from the condition
in its computation of the empirical density instead of all p pairs;
by default, all pairs are used. We suggest use of this option when
the number of pairs is very large
}
  \item{\dots}{
Other parameters to be passed to plot()
}
}
\details{
This function is a diagnostic tool for checking the prior distribution
selected by the EM during an ebCoexpressSeries function's computations
using the prior predictive distribution. The better the prior fits the
observed data, the more confidence
we should have in the posterior probabilities generated by the EM.

When run, the user specifies a condition. All of the (transformed)
correlations from that condition (or just some of them if the subsize=
option is non-NULL) will be used to estimate the empirical prior predictive
distribution of the data in that condition; this will be plotted in black.
The diagnostic then calculates the the theoretical prior predictive
distribution and plots it using a dashed, colored line (set by colx=).
If the two densities are similar, this indicates the selected prior
fits the data in this condition well. The process can and should
be repeated for all other conditions
}
\value{
Returns invisible(NULL)
}
\references{
Dawson JA and Kendziorski C. An empirical Bayesian approach for
identifying differential co-expression in high-throughput experiments.
(2011) Biometrics. E-publication before print:
http://onlinelibrary.wiley.com/doi/10.1111/j.1541-0420.2011.01688.x/abstract
}
\author{
John A. Dawson <jadawson@wisc.edu>
}

\examples{
data(fiftyGenes)
tinyCond <- c(rep(1,100),rep(2,25))
tinyPat <- ebPatterns(c("1,1","1,2"))
D <- makeMyD(fiftyGenes, tinyCond, useBWMC=TRUE)
set.seed(3)
initHP <- initializeHP(D, tinyCond)

zout <- ebCoexpressZeroStep(D, tinyCond, tinyPat, initHP)
par(mfrow=c(2,1))
priorDiagnostic(D, tinyCond, zout, 1)
priorDiagnostic(D, tinyCond, zout, 2)
par(mfrow=c(1,1))
}

\keyword{ models }
