% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{RNADuplexesRawBed}
\alias{RNADuplexesRawBed}
\title{Chimeric reads of SPLASH converted to .bedpe fromat}
\format{
An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 2040 rows and 10 columns.
}
\source{
\href{https://www.ncbi.nlm.nih.gov/sra/?term=SRR3404943}{SequenceReadArcive}
Reads were aligned with STAR and filtered to contain only reads
which could be represented as 2-arm chimeric alignments. Converted to the
\href{https://bedtools.readthedocs.io/en/latest/content/general-usage.html#bedpe-format}{bedpe}
format
see \code{system.file("extdata/scripts", "DD_data_generation.R", package =
"DuplexDiscovereR")} for details on the pre-processing and sub-setting the
data
}
\usage{
data(RNADuplexesSampleData)
}
\value{
\code{tibble} with columns of bedpe format
}
\description{
A Chimeric.out.Junction file with a subset of chr 22 Chimeric reads
detected by SPLASH protocol in Human embryonic stem cells.
}
\keyword{datasets}
