\name{GPo_of_hotspots}
\alias{GPo_of_hotspots}
\title{Converts hotspot mutation table into a GPo object}
\usage{
  GPo_of_hotspots(hotspot_mutations)
}
\arguments{
  \item{hotspot_mutations}{Data frame with information on hotspot mutations generated by the DominoEffect package.}

}

\value{GPo object that contains the genomic information on hotspot mutations.}

\description{This function converts the genomic information on hotspot mutations into a GPo object.}
\examples{

data("SnpData", package = "DominoEffect")
data("TestData", package = "DominoEffect")
data("DominoData", package = "DominoEffect")

hotspot_mutations <- DominoEffect(mutation_dataset = TestData, 
gene_data = DominoData, snp_data = SnpData)
GPo_of_hotspots(hotspot_mutations)

}
\author{
  Marija Buljan <buljan@imsb.biol.ethz.ch>
  Peter Blattmann <blattmann@imsb.biol.ethz.ch>
}
