% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco.R
\name{discoPeriodDetection}
\alias{discoPeriodDetection}
\title{Detect dataset-wide fits to multiple periodicities}
\usage{
discoPeriodDetection(
  se,
  timeType = c("linear", "circular"),
  main_per = 24,
  test_periods = NULL
)
}
\arguments{
\item{se}{SummarizedExperiment, the main data object used by DiscoRhythm 
expected to contain se$ID, se$ReplicateID, se$Time sample metadata and
non-null rownames. See the vignette for more details.}

\item{timeType}{character, time is either reported as "linear" or
"circular" on some base-cycle (ex. time of day). This determines the periods
that will be tested for.}

\item{main_per}{numeric, if \code{timeType=="circular"} main_per
indicates the period of the base-cycle where sampling times are derived.}

\item{test_periods}{numeric, a vector of the periods to test.
if \code{timeType=="linear"} and length(test_periods)==2 it will be assumed
to be a range of periods to test over.}
}
\value{
A data.frame of Rsquared values for each period, for each row of
Maindata.
}
\description{
Detect dataset-wide fits to multiple periodicities
}
\examples{
se <- discoGetSimu(TRUE)

# Detect periods
rsqs <- discoPeriodDetection(se)

}
